--Consider
SELECT t.year,t.month,format(sum(s.profit),'C') as total_profit
FROM sales_enriched as s JOIN times as t ON s.date=t.date
GROUP BY t.year,t.month
ORDER BY t.year,t.month

--Subtotals
SELECT t.year,t.month,format(sum(s.profit),'C') as total_profit
FROM sales_enriched as s JOIN times as t ON s.date=t.date
GROUP BY GROUPING SETS ((t.year,t.month),(t.year),())

--Rollup
SELECT t.year,t.month,format(sum(s.profit),'C') as total_profit
FROM sales_enriched as s JOIN times as t ON s.date=t.date
GROUP BY ROLLUP(t.year,t.month)
--equivalent to 
--GROUP BY GROUPING SETS ((t.year,t.month),(t.year),())

--Cube
SELECT t.year,t.month,format(sum(s.profit),'C') as total_profit
FROM sales_enriched as s JOIN times as t ON s.date=t.date
GROUP BY CUBE(t.year,t.month)
--equivalent to 
--GROUP BY GROUPING SETS ((t.year,t.month),(t.year),(t.month),())

--Fancy output?
SELECT t.year,t.month,format(sum(s.profit),'C') as total_profit
FROM sales_enriched as s JOIN times as t ON s.date=t.date
GROUP BY t.year,t.month
UNION ALL
SELECT 'Total for year '+t.year,'',format(sum(s.profit),'C') as total_profit
FROM sales_enriched as s JOIN times as t ON s.date=t.date
GROUP BY t.year
UNION ALL
SELECT 'Grand Total','',format(sum(s.profit),'C') as total_profit
FROM sales_enriched as s JOIN times as t ON s.date=t.date

--The datatypes must match
SELECT cast(t.year as char(25)) as year,cast(t.month as char(10)) as month
       ,format(sum(s.profit),'C') as total_profit
FROM sales_enriched as s JOIN times as t ON s.date=t.date
GROUP BY t.year,t.month
UNION ALL
SELECT 'Total for year '+cast(t.year as char(5)),''
       ,format(sum(s.profit),'C') as total_profit
FROM sales_enriched as s JOIN times as t ON s.date=t.date
GROUP BY t.year
UNION ALL
SELECT 'Grand Total',''
       ,format(sum(s.profit),'C') as total_profit
FROM sales_enriched as s JOIN times as t ON s.date=t.date

--Getting the right order is difficult
SELECT cast(t.year as char(25)) as year,cast(t.month as char(10)) as month
       ,format(sum(s.profit),'C') as total_profit
FROM sales_enriched as s JOIN times as t ON s.date=t.date
GROUP BY t.year,t.month
UNION ALL
SELECT 'Total for year '+cast(t.year as char(5)),''
       ,format(sum(s.profit),'C') as total_profit
FROM sales_enriched as s JOIN times as t ON s.date=t.date
GROUP BY t.year
UNION ALL
SELECT 'Grand Total',''
       ,format(sum(s.profit),'C') as total_profit
FROM sales_enriched as s JOIN times as t ON s.date=t.date
ORDER BY year,month --doesn't work as year, month are in alphabetical order